

# CommandCurrentType

<div class="api-docs__separator">

---

</div><div class="api-docs__import">

```ts
import { CommandCurrentType } from "@hyper-fetch/core"
```

</div><div class="api-docs__section">

## Description

</div><div class="api-docs__description"><span class="api-docs__do-not-parse">



</span></div><p class="api-docs__definition">

Defined in [command/command.types.ts:168](https://github.com/BetterTyped/hyper-fetch/blob/3fe127e9/packages/core/src/command/command.types.ts#L168)

</p><div class="api-docs__section">

## Preview

</div><div class="api-docs__preview type single">

```ts
type CommandCurrentType<ResponseType,RequestDataType,QueryParamsType,ErrorType,GenericEndpoint,ClientOptions,MappedData> = { data?: CommandData<RequestDataType, MappedData>; headers?: HeadersInit; mockCallback?: (data: RequestDataType) => ClientResponseType<ResponseType, ErrorType>; params?: ExtractRouteParams<GenericEndpoint> | NegativeTypes; queryParams?: QueryParamsType | NegativeTypes; updatedAbortKey?: boolean; updatedCacheKey?: boolean; updatedEffectKey?: boolean; updatedQueueKey?: boolean; used?: boolean } & Partial<NullableKeys<CommandConfig<GenericEndpoint, ClientOptions>>>;
```

</div><div class="api-docs__section">

## Structure

</div><div class="api-docs__returns">

```ts
{
  data: MappedData extends undefined ? RequestDataType : MappedData | \null\ | \undefined\;
  headers: HeadersInit;
  mockCallback: (data: RequestDataType) => ClientResponseType<ResponseType, ErrorType>;
  params: string extends T ? NegativeTypes : (T extends `${string}:,${infer Param}/,${infer Rest}` ? [k in \Param\ | \keyof ExtractRouteParams<Rest>\]: ParamType : (T extends `${string}:,${infer Param}` ? [k in Param]: ParamType : NegativeTypes)) | \null\ | \undefined\;
  queryParams: QueryParamsType | \null\ | \undefined\;
  updatedAbortKey: boolean;
  updatedCacheKey: boolean;
  updatedEffectKey: boolean;
  updatedQueueKey: boolean;
  used: boolean;
  ...params2: Partial<NullableKeys<CommandConfig<GenericEndpoint, ClientOptions>>>;
}
```

</div>